<?php
session_start();
error_reporting(0);
header('Content-Type: text/html; charset=utf-8');

// بررسی وجود پرداخت موفق
if (!isset($_SESSION['payment_success'])) {
    header("Location: ../");
    exit;
}

// دریافت اطلاعات سفارش
$order = $_SESSION['order'];
$paymentFile = "payments/payment_{$order['order_id']}.json";
$paymentData = json_decode(file_get_contents($paymentFile), true);

// تولید کد پیگیری ۱۲ رقمی
$trackingCode = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 12);

// تاریخ و ساعت دقیق با فرمت پیشرفته
$paymentDate = new DateTime('now', new DateTimeZone('Asia/Tehran'));
$formattedDate = $paymentDate->format('Y/m/d H:i:s');

// پاک کردن سشن‌ها
unset($_SESSION['cart']);
unset($_SESSION['order']);
unset($_SESSION['payment_success']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پرداخت موفق | فروشگاه ما</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --secondary: #3a0ca3;
            --success: #4cc9f0;
            --light: #f8f9fa;
            --dark: #212529;
            --white: #ffffff;
            --gradient: linear-gradient(135deg, var(--primary), var(--secondary));
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazir', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .success-container {
            background: var(--white);
            border-radius: 20px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 600px;
            padding: 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .success-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 10px;
            background: var(--gradient);
        }

        .success-icon {
            width: 100px;
            height: 100px;
            background: #e8f5e9;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: var(--success);
            font-size: 50px;
            animation: bounce 1s;
        }

        @keyframes bounce {

            0%,
            20%,
            50%,
            80%,
            100% {
                transform: translateY(0);
            }

            40% {
                transform: translateY(-20px);
            }

            60% {
                transform: translateY(-10px);
            }
        }

        h1 {
            color: var(--success);
            margin-bottom: 15px;
            font-size: 28px;
        }

        .success-message {
            color: var(--dark);
            margin-bottom: 30px;
            font-size: 16px;
        }

        .receipt-box {
            background: rgba(76, 201, 240, 0.1);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            text-align: right;
            border: 1px dashed rgba(76, 201, 240, 0.3);
        }

        .receipt-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .receipt-row:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
            font-weight: bold;
            color: var(--primary);
        }

        .tracking-code {
            font-family: 'Courier New', monospace;
            letter-spacing: 2px;
            font-weight: bold;
        }

        .payment-time {
            direction: ltr;
            display: inline-block;
        }

        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: var(--gradient);
            color: white;
            border-radius: 30px;
            text-decoration: none;
            font-weight: bold;
            margin-top: 20px;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }

        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(67, 97, 238, 0.4);
        }

        .btn i {
            margin-left: 8px;
        }

        .floating-shapes {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }

        .shape {
            position: absolute;
            opacity: 0.1;
            animation: float 15s infinite linear;
        }

        .shape.circle {
            border-radius: 50%;
            background: var(--primary);
        }

        @keyframes float {
            0% {
                transform: translateY(0) rotate(0deg);
            }

            100% {
                transform: translateY(-1000px) rotate(720deg);
            }
        }

        /* استایل برای چاپ */
        @media print {
            body {
                background: none;
                padding: 0;
            }

            .success-container {
                box-shadow: none;
                max-width: 100%;
            }

            .btn,
            .floating-shapes {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="success-container">
        <div class="floating-shapes">
            <div class="shape circle"
                style="width: 100px; height: 100px; top: 10%; left: 10%; animation-duration: 20s;"></div>
            <div class="shape circle"
                style="width: 150px; height: 150px; top: 60%; left: 70%; animation-duration: 25s;"></div>
            <div class="shape circle" style="width: 80px; height: 80px; top: 30%; left: 80%; animation-duration: 15s;">
            </div>
        </div>

        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>

        <h1>پرداخت شما با موفقیت انجام شد!</h1>
        <p class="success-message">سفارش شما ثبت شد و جزئیات به ایمیل و پیامک شما ارسال گردید</p>

        <div class="receipt-box">
            <div class="receipt-row">
                <span>شماره سفارش:</span>
                <span>#<?= $order['order_id'] ?></span>
            </div>
            <div class="receipt-row">
                <span>کد پیگیری بانکی:</span>
                <span class="tracking-code"><?= $trackingCode ?></span>
            </div>
            <div class="receipt-row">
                <span>تاریخ و ساعت پرداخت:</span>
                <span class="payment-time"><?= $formattedDate ?></span>
            </div>
            <div class="receipt-row">
                <span>مبلغ پرداختی:</span>
                <span><?= number_format($order['amount']) ?> تومان</span>
            </div>
            <div class="receipt-row">
                <span>وضعیت سفارش:</span>
                <span>تکمیل شده</span>
            </div>
        </div>

        <p>رسید پرداخت به شماره موبایل شما ارسال شد</p>
        <a href="/Film_Sex/index.php" class="btn">
            <i class="fas fa-home"></i> بازگشت به فروشگاه
        </a>

        <button onclick="window.print()" class="btn" style="margin-left: 10px; background: var(--secondary);">
            <i class="fas fa-print"></i> چاپ رسید
        </button>
    </div>
</body>

</html>